/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.config;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.registry.config.MCFIterator;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.config.Profiles;
import org.orecruncher.dsurround.registry.config.packs.IMyResourcePack;
import org.orecruncher.dsurround.registry.config.packs.ResourcePacks;

public final class ConfigData
implements Iterable<ModConfiguration> {
    private final byte[] crunchyBits;

    private ConfigData(@Nonnull byte[] theBits) {
        this.crunchyBits = theBits;
    }

    public Stream<ModConfiguration> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private static void injectString(@Nonnull String txt, @Nonnull OutputStreamWriter out) {
        try {
            out.write(34);
            out.write(txt);
            out.write("\",");
        }
        catch (Throwable t) {
            ModBase.log().error("Really??", t);
        }
    }

    protected static void appendComma(@Nonnull OutputStreamWriter out) {
        try {
            out.write(44);
        }
        catch (Throwable t) {
            ModBase.log().error("Really??", t);
        }
    }

    protected static void copy(@Nonnull BufferedReader reader, @Nonnull OutputStreamWriter out) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String s = line.trim();
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                out.write(s);
            }
        }
        catch (IOException e) {
            ModBase.log().error("Huh?", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean copy(@Nonnull InputStreamReader in, @Nonnull OutputStreamWriter out, @Nonnull String text, boolean comma) {
        try (BufferedReader reader = new BufferedReader(in);){
            try {
                reader.mark(131072);
                JsonReader r = new JsonReader((Reader)reader);
                ModConfiguration modConfiguration = (ModConfiguration)new Gson().fromJson((Reader)reader, ModConfiguration.class);
            }
            finally {
                reader.reset();
            }
            if (comma) {
                ConfigData.appendComma(out);
            }
            ConfigData.injectString(text, out);
            ConfigData.copy(reader, out);
            ModBase.log().debug("Loaded %s", new Object[]{text});
            boolean bl = true;
            return bl;
        }
        catch (JsonSyntaxException | MalformedJsonException vf) {
            ModBase.log().warn("Json validation failed for %s: %s", new Object[]{text, vf.getMessage()});
            return comma;
        }
        catch (Throwable t) {
            ModBase.log().error(text, t);
        }
        return comma;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected static boolean copy(@Nonnull IMyResourcePack p, @Nonnull ResourceLocation rl, @Nonnull OutputStreamWriter output, @Nullable String text, boolean comma) {
        block31: {
            try {
                Throwable throwable = null;
                try (InputStream is = p.getInputStream(rl);){
                    boolean bl;
                    Throwable throwable2;
                    InputStreamReader stream;
                    block32: {
                        block33: {
                            if (is == null) break block31;
                            stream = new InputStreamReader(is);
                            throwable2 = null;
                            bl = ConfigData.copy(stream, output, text, comma);
                            if (stream == null) break block32;
                            if (throwable2 == null) break block33;
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            break block32;
                        }
                        stream.close();
                    }
                    return bl;
                    catch (Throwable throwable4) {
                        try {
                            try {
                                try {
                                    throwable2 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (stream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                stream.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable2.addSuppressed(throwable6);
                                            }
                                        } else {
                                            stream.close();
                                        }
                                    }
                                    throw throwable5;
                                }
                            }
                            catch (Throwable t) {
                                ModBase.log().error(rl.toString(), t);
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throw throwable8;
                        }
                    }
                }
            }
            catch (Throwable t) {
                ModBase.log().error(rl.toString(), t);
            }
        }
        return comma;
    }

    @Nonnull
    private static File getFileReference(@Nonnull String dataFile) {
        String workingFile = StringUtils.appendIfMissing((String)Paths.get(dataFile, new String[0]).getFileName().toString(), (CharSequence)".json", (CharSequence[])new CharSequence[0]);
        return new File(ModBase.dataDirectory(), workingFile);
    }

    public static ConfigData load() {
        FastByteArrayOutputStream bits = new FastByteArrayOutputStream(16384);
        try (OutputStreamWriter output = new OutputStreamWriter(new GZIPOutputStream((OutputStream)bits));){
            output.write("[");
            boolean prependComma = false;
            List<IMyResourcePack> packs = ResourcePacks.findResourcePacks();
            List activeMods = Loader.instance().getActiveModList();
            for (Object mod : activeMods) {
                ResourceLocation rl = new ResourceLocation("dsurround", "data/" + mod.getModId().toLowerCase() + ".json");
                for (IMyResourcePack p : packs) {
                    if (!p.resourceExists(rl)) continue;
                    prependComma = ConfigData.copy(p, rl, output, "[" + rl.toString() + "] from [" + p.getModName() + "]", prependComma);
                }
            }
            ResourceLocation rl = ResourcePacks.CONFIGURE_RESOURCE;
            for (IMyResourcePack p : packs) {
                if (!p.resourceExists(rl)) continue;
                prependComma = ConfigData.copy(p, rl, output, "[" + rl.toString() + "] from [" + p.getModName() + "]", prependComma);
            }
            List<Profiles.ProfileScript> resources = Profiles.getProfileStreams();
            for (Profiles.ProfileScript script : resources) {
                try {
                    InputStreamReader reader = new InputStreamReader(script.stream);
                    Throwable throwable = null;
                    try {
                        prependComma = ConfigData.copy(reader, output, script.packName, prependComma);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable t) {
                    ModBase.log().error("Error reading profile script", t);
                }
            }
            for (String cfg : ModOptions.general.externalScriptFiles) {
                File file = ConfigData.getFileReference(cfg);
                if (!file.exists()) continue;
                ModBase.log().info("Loading external configuration script '%s'", new Object[]{cfg});
                try (FileInputStream stream = new FileInputStream(file);){
                    try (InputStreamReader input = new InputStreamReader(stream);){
                        prependComma = ConfigData.copy(input, output, cfg, prependComma);
                    }
                    catch (Throwable t) {
                        ModBase.log().error(String.format("Unable to load configuration script '%s'", cfg), t);
                    }
                }
                catch (Throwable t) {
                    ModBase.log().error(String.format("Unable to load configuration script '%s'", cfg), t);
                }
            }
            output.write("]");
            output.flush();
        }
        catch (Throwable t) {
            ModBase.log().error("Something went horribly wrong", t);
        }
        bits.trim();
        return new ConfigData(bits.array);
    }

    @Override
    @Nonnull
    public Iterator<ModConfiguration> iterator() {
        try {
            return new MCFIterator(this.crunchyBits);
        }
        catch (Throwable t) {
            ModBase.log().error("Unable to create ModConfiguration iterator", t);
            return new Iterator<ModConfiguration>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ModConfiguration next() {
                    throw new IllegalStateException("Huh?");
                }
            };
        }
    }

    protected static void dump(@Nonnull byte[] demBytes) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)new FastByteArrayInputStream(demBytes)), StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                ModBase.log().info(line, new Object[0]);
            }
        }
        catch (Throwable t) {
            ModBase.log().error("Error dumping bytes!", t);
        }
    }
}

